package jadean.dean.java.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class JavaUtilities {

	/*
	 * converts array of type T to list of type T
	 */
	public static <T> ArrayList<T> arrayToList(T[] in) {
		ArrayList<T> ret = new ArrayList<T>(); 
		for (T t: in) {
			ret.add(t);
		}
		return ret;
	}

	public static <T> boolean inCollection(Collection<T> collection, T item) {
		for (T i: collection) {
			if (i.equals(item)) {
				return true;
			}
		}
		return false;
	}
	
	public static <T> boolean inArray(T[] array, T item) {
		for (T i: array) {
			if (i.equals(item)) {
				return true;
			}
		}
		return false;
	}	
	
	public static <T> boolean containsItem(T[] array, Selector<T> selector) {
		for (T i: array) {
			if (selector.accept(i)) {
				return true;
			}
		}
		return false;
	}	
	
	public static <T> boolean containsItem(Collection<T> collection, Selector<T> selector) {
		for (T i: collection) {
			if (selector.accept(i)) {
				return true;
			}
		}
		return false;
	}		
	
	public static <T> boolean arraysEquals(T[] array1, T[] array2) {
		List<T> list1 = arrayToList(array1);
		List<T> list2 = arrayToList(array2);
		
		return collectionsEquals(list1, list2);
	}
	
	public static <T> boolean collectionsEquals(Collection<T> col1, Collection<T> col2) {
		return col1.containsAll(col2) && col2.containsAll(col1);
	}

	/*
	 * returns true, if given className is atomic
	 */
	public static boolean isAtomicClassName(String className) {
		return (className.indexOf('.') == -1);
	}

	/*
	 * concatenates class package and class name to fully qualified class name
	 */
	public static String buildFullyQualifiedClassName(String classPackage, String className) {
		if ("".equals(classPackage)) {
			return className;
		}
		return classPackage + "." + className;
	}

	/*
	 * returns package of fully qualified class name
	 */
	public static String extractPackage(String fQClassName) {
		int i = fQClassName.lastIndexOf('.');
		if (i == -1) {
			return "";
		}
		return fQClassName.substring(0, i);
	}

	/*
	 * returns class name of fully qualified class name
	 */
	public static String extractClassName(String fQClassName) {
		int i = fQClassName.lastIndexOf('.');
		if (i == -1) {
			return fQClassName;
		}
		return fQClassName.substring(i + 1);
	}
}
